/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSClientPropertyValidator;
import filenet.ws.listener.axis.rm.WSUUIDGenFactory;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.sandesha.IStorageManager;
import org.apache.sandesha.RMMessageContext;
import org.apache.sandesha.RMReport;
import org.apache.sandesha.client.ClientStorageManager;
import org.apache.sandesha.util.PolicyLoader;
import org.apache.sandesha.util.RMMessageCreator;
import org.apache.sandesha.ws.rm.RMHeaders;

public class WSRMSender
extends BasicHandler {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    private static final String m_className = "WSRMSender";
    private IStorageManager storageManager;
    private final UUIDGen uuidGen = WSUUIDGenFactory.getUUIDGen();
    private static Boolean lock = new Boolean(false);

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 21:15:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        String m_method = "invoke";
        logger.entering(m_className, m_method);
        this.storageManager = new ClientStorageManager();
        try {
            RMMessageContext reqMsgCtx = null;
            String tempSeqID = null;
            reqMsgCtx = this.getRMMessageContext(msgContext);
            tempSeqID = reqMsgCtx.getSequenceID();
            reqMsgCtx = this.processRequestMessage(reqMsgCtx, reqMsgCtx.getSync());
            if (reqMsgCtx.isHasResponse()) {
                Call call;
                String oldSeqId;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "request/response");
                }
                RMMessageContext responseMessageContext = null;
                long startingTime = System.currentTimeMillis();
                long inactivityTimeOut = PolicyLoader.getInstance().getInactivityTimeout();
                while (responseMessageContext == null) {
                    Boolean bl = lock;
                    synchronized (bl) {
                        responseMessageContext = this.checkTheQueueForResponse(tempSeqID, reqMsgCtx.getMessageID());
                        if (System.currentTimeMillis() - startingTime >= inactivityTimeOut) {
                            reqMsgCtx.getCtx().stopClientByForce();
                        }
                        Thread.sleep(500L);
                    }
                }
                if (responseMessageContext != null && (oldSeqId = reqMsgCtx.getOldSequenceID()) != null && (call = (Call)reqMsgCtx.getCtx().getCallMap().get(reqMsgCtx.getOldSequenceID())) != null) {
                    RMReport report = (RMReport)call.getProperty("report");
                    report.incrementReturnedMsgCount();
                }
                Message resMsg = responseMessageContext.getMsgContext().getRequestMessage();
                RMHeaders.removeHeaders((org.apache.axis.message.SOAPEnvelope)resMsg.getSOAPEnvelope());
                AddressingHeaders addHeaders = new AddressingHeaders((SOAPEnvelope)resMsg.getSOAPEnvelope(), null, true, true, false, null);
                msgContext.setResponseMessage(new Message((Object)resMsg.getSOAPPartAsString()));
            } else {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "one way request");
                }
                msgContext.setResponseMessage(null);
            }
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
            throw new AxisFault(ex.getMessage());
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMMessageContext processRequestMessage(RMMessageContext reqRMMsgContext, boolean sync) throws Exception {
        Boolean bl = lock;
        synchronized (bl) {
            if (!this.storageManager.isSequenceExist(reqRMMsgContext.getSequenceID())) {
                String msgID = "uuid:" + this.uuidGen.nextUUID();
                String offerID = null;
                if (reqRMMsgContext.isHasResponse() && reqRMMsgContext.isSendOffer()) {
                    offerID = "uuid:" + this.uuidGen.nextUUID();
                    this.storageManager.addRequestedSequence(offerID);
                    this.storageManager.addOffer(msgID, offerID);
                }
                RMMessageContext createSeqRMMsgContext = RMMessageCreator.createCreateSeqMsg((RMMessageContext)reqRMMsgContext, (byte)0, (String)msgID, offerID);
                this.storageManager.addOutgoingSequence(reqRMMsgContext.getSequenceID());
                this.storageManager.setTemporaryOutSequence(reqRMMsgContext.getSequenceID(), createSeqRMMsgContext.getMessageID());
                createSeqRMMsgContext.setSync(sync);
                this.storageManager.addCreateSequenceRequest(createSeqRMMsgContext);
                this.processMessage(reqRMMsgContext);
            } else {
                this.processMessage(reqRMMsgContext);
            }
        }
        return reqRMMsgContext;
    }

    private RMMessageContext processMessage(RMMessageContext reqRMMsgContext) throws Exception {
        if (reqRMMsgContext.isLastMessage()) {
            this.storageManager.insertTerminateSeqMessage(RMMessageCreator.createTerminateSeqMsg((RMMessageContext)reqRMMsgContext, (byte)0));
        }
        RMMessageContext serviceRequestMsg = RMMessageCreator.createServiceRequestMessage((RMMessageContext)reqRMMsgContext);
        this.storageManager.insertOutgoingMessage(serviceRequestMsg);
        return reqRMMsgContext;
    }

    private RMMessageContext checkTheQueueForResponse(String sequenceId, String reqMessageID) {
        return this.storageManager.checkForResponseMessage(sequenceId, reqMessageID);
    }

    private RMMessageContext getRMMessageContext(MessageContext msgCtx) throws Exception {
        MessageContext newMsgContext = RMMessageCreator.cloneMsgContext((MessageContext)msgCtx);
        RMMessageContext requestMesssageContext = new RMMessageContext();
        Call call = (Call)newMsgContext.getProperty("call_object");
        requestMesssageContext = WSClientPropertyValidator.validate(call);
        requestMesssageContext.setOutGoingAddress((String)msgCtx.getProperty("transport.url"));
        requestMesssageContext.setMsgContext(newMsgContext);
        return requestMesssageContext;
    }
}

